<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:HTML='http://www.w3.org/Profiles/XHTML-transitional' xmlns:dt='urn:schemas-microsoft-com:datatypes'>

	<xsl:output method='html'/>



	<xsl:variable name='resource' select='document("../../ide/documents/titoresource.xml")/resource'/>



	<xsl:template match='@* | node()'>

		<xsl:copy><xsl:apply-templates select="@* | node()"/></xsl:copy>

	</xsl:template>

	

	<xsl:strip-space elements="*"/>





	<xsl:template match='commandbar'>

		<xsl:call-template name='commandBar'/>

	</xsl:template>



	<xsl:template match='command[parent::commandbar]'>

		<xsl:call-template name='commandBarItem'/>

	</xsl:template>



	<xsl:template match='/command'>

		<xsl:call-template name='commandList'/>

	</xsl:template>



	<xsl:template match='command[parent::command]'>

		<xsl:call-template name='commandListItem'/>

	</xsl:template>



	<xsl:template match='separator[parent::command]'>

		<xsl:call-template name='separator'/>

	</xsl:template>





	<xsl:template name='commandBar'>

		<table class="menubar" id='{@id}' cellpadding="0" cellspacing="2">

			<tr>

				<xsl:apply-templates/>

				<td class="commandBar_filler"></td>

			</tr>

		</table>

	</xsl:template>

	

	<xsl:template name='commandBarItem'>

		<xsl:variable name='cmdID' select='@commandid'/>

		<xsl:variable name='cmdNode' select='$resource/commands//command[@id = $cmdID]'/>

		<xsl:variable name='cmdStatus' select='@status | $cmdNode/@status'/>

		

		<td id="menu_{$cmdNode/@id}" commandid="{$cmdNode/@id}" nowrap="1" title="{$cmdNode/@tooltip}" level="0" status="{$cmdStatus}">

			<xsl:apply-templates select='$cmdNode/@name | $cmdNode/@action | $cmdNode/@shortcut | $cmdNode/@image | $cmdNode/@type | @checked'/>

			<xsl:attribute name='class'>menubar_common commandbar_item_<xsl:value-of select='$cmdStatus'/></xsl:attribute>

			

			<div class="commandbar_item_content"><xsl:value-of select='$cmdNode/@name'/></div>

			

			<xsl:call-template name='commandList'/>

		</td>

	</xsl:template>

	

	<xsl:template name='commandList'>

		<xsl:if test='command'>

			<div id="menu_{@commandid}_commandList">

				<xsl:attribute name='class'>

					<xsl:choose>

						<xsl:when test='ancestor::commandbar or parent::command'>commandlist_hidden</xsl:when>

						<xsl:otherwise>commandlist_opened</xsl:otherwise>

					</xsl:choose>

				</xsl:attribute>



				<table cellpadding="0" cellspacing="0">

					<xsl:apply-templates/>

				</table>

			</div>

		</xsl:if>

	</xsl:template>



	<xsl:template name='commandListItem'>

		<xsl:variable name='cmdID' select='@commandid'/>

		<xsl:variable name='cmdNode' select='$resource/commands//command[@id = $cmdID]'/>

		<xsl:variable name='level' select='count(ancestor::*[name()="command"])'/>

		<xsl:variable name='cmdStatus' select='@status | $cmdNode/@status'/>

		

		<tr id="menu_{$cmdNode/@id}" commandid="{$cmdNode/@id}" title="{$cmdNode/@tooltip}" level="{$level}" status="{$cmdStatus}">

			<xsl:apply-templates select='$cmdNode/@name | $cmdNode/@action | $cmdNode/@shortcut | $cmdNode/@image | $cmdNode/@type | @checked'/>

			<xsl:attribute name='class'>commandlist_common commandlist_item_<xsl:value-of select='$cmdStatus'/></xsl:attribute>

			

			<td class="command_icon_common command_icon">

				<div>

					<xsl:choose>

						<xsl:when test='$cmdNode/@type = "check" and @checked'><img src="../apt/images/check.gif"/></xsl:when>

						<xsl:when test='not($cmdNode/@type) and $cmdNode/@image'><img src="../apt/images/{$cmdNode/@image}.gif"/></xsl:when>

						<xsl:otherwise>&#160;</xsl:otherwise>

					</xsl:choose>

				</div>

			</td>

			<td class="command_content_common command_content" nowrap="1">

				<span class="command_name"><xsl:value-of select='$cmdNode/@name'/>&#160;&#160;</span>

				<span class="command_shortcut">&#160;&#160;<xsl:value-of select='$cmdNode/@shortcut'/></span>

			</td>

			<td class="command_arrow_common command_arrow">

				<div><xsl:if test='command'><img src="../apt/images/commandlist.gif"/></xsl:if></div>

				

				<xsl:call-template name='commandList'/>

			</td>

		</tr>



	</xsl:template>



	<!-- Template for separator -->	

	<xsl:template name='separator'>

		<xsl:choose>

			<xsl:when test='parent::commandbar'>

				<xsl:call-template name='commandbarSeparator'/>

			</xsl:when>

			<xsl:when test='parent::command'>

				<xsl:call-template name='commandSeparator'/>

			</xsl:when>

		</xsl:choose>

	</xsl:template>



	<!-- Template for horizontal separator in command bar -->	

	<xsl:template name='commandbarSeparator'>

		<td class="separator" level="0">&#160;</td>

	</xsl:template>



	<!-- Template for vertical separator in command list -->	

	<xsl:template name='commandSeparator'>

		<xsl:variable name='level' select='count(ancestor::*[name()="command"])'/>

		<tr class="separator" level="{$level}">

			<td class="separator_icon"></td>

			<td class="separator_line" colspan="2"></td>

		</tr>

	</xsl:template>



</xsl:stylesheet>

